#include "C:\\Program Files\\Fed\\Pixie\\Projects\\Bingo\\bingo_Auto.h"
#include <maths.h>
#include <delays.h>

//
// Bingo machine
//
// Generates random numbers, stores and displays and uses keypad to check
//  David Coward
//
// 	Version 	Comment
//	0.8 		First go
//	0.9		Minor tweaks, avoiding RA4, set maximum number
//	1.0		Outputs numbers
//	1.01		Change to output format
//	1.02		Delay intialise for big digits
//
//#define debug

//
// functions
//

void Display();
void Update();
void sound(unsigned int duration, unsigned int freq, unsigned char mod);
void KeyPress();
void wait_turn();
void gen_number();
void bin2bcd(unsigned int val);
unsigned char checknumber(unsigned char testval);
void checking();
void rewind();
void setup();
void clear();
void cleareeprom();
void map();
void send();
void start_up();

//
// Variables
//

unsigned char i, j, Ds[3], pattern, segments[17];
unsigned char flashcount, modcount;
unsigned char mode, intcount;
unsigned int intcount6, sound_count, frequency, duration;
unsigned char in_no;
unsigned char number, secs, turn_secs;
unsigned char tens, units, test;
unsigned char good_no, curmem, memloc, checkloc;
unsigned char random, maxno=90;
unsigned int zz;
unsigned char so, key, sendno;

//
// structures
//

struct flag
{
 unsigned char autogenled:1;
 unsigned char onled:1;
 unsigned char okled:1;
 unsigned char setled:1;
 unsigned char good:1;
 unsigned char modulate:1;
 unsigned char soundon:1;
 unsigned char maxno:1;
};

flag flags;

struct led
{
 unsigned char on:2;
 unsigned char autogen:2;
 unsigned char set:2;
 unsigned char ok:2;
};

led leds1;

void UserInterrupt()
{
 #asmline SETPCLATH UserIntReturn,-1  ; SETPCLATH for interrupt routine
 #asmline goto UserIntReturn	      ; As
}

//
// Initialisation
//

void UserInitialise()
{
 
 ADCON1=7;
 
 TRISC=0;
 TRISB=0;
 
 memloc=0;
 
 srand(T0ExtCount);
 
 #ifdef debug
 
  turn_secs=5;
  
  segments[0]=0x7e;
  segments[1]=0x0c;
  segments[2]=0xb6;
  segments[3]=0x9e;
  segments[4]=0xcc;
  segments[5]=0xda;
  segments[6]=0xfa;
  segments[7]=0x0e;
  segments[8]=0xfe;
  segments[9]=0xde;
  segments[10]=0xf2;	// E
  segments[11]=0xf0;	// t
  segments[12]=0x7c;	// U 
  segments[13]=0x00;
  segments[14]=0x72;	// C 
  segments[15]=0xee;	// R
  segments[16]=0x80;	// -

 #else
 
  turn_secs=5;
  
  segments[0]=0x80;
  segments[1]=0xf2;
  segments[2]=0x48;
  segments[3]=0x60;
  segments[4]=0x32;
  segments[5]=0x24;
  segments[6]=0x04;
  segments[7]=0xf0;
  segments[8]=0x00;
  segments[9]=0x20;
  segments[10]=0x0c;	// E
  segments[11]=0x0e;	// t
  segments[12]=0x82;	// U
  segments[13]=0xfe;
  segments[14]=0x8c;	// C
  segments[15]=0x10;	// R
  segments[16]=0x7e;	// -
  
 #endif
  
 start_up();

 number=0; clear();  cleareeprom(); 
 
 mode=0;

}

//*******************************************************************************
//
// Insert your main loop code if required here. This routine will be called
// as part of the main loop code
//

void UserLoop()
{
 srand(random);		// seed the random number generator
}

//
// User occurrence code
//

void Display()
{
 
 Update();
 
 PORTC=PORTC&(0x00<<i);
  
 i++; if (i==2) i=0;
 
 pattern=Ds[i];
     
 PORTB=segments[pattern];
 	 
 PORTC=PORTC|(0x01<<i);
  
}

//
// Sound producer
//
//
// Trivial routine to make a noise using a ceramic resonator
// makes a square wave on a port of rough frequency and duration.
//

void Sounder()
{
 if (sound_count>0)
 {
 intcount6++;
  if (flags.soundon)
   {
    if (intcount6&frequency) SoundPort|=(1<<SoundBit);
    else SoundPort&=~(1<<SoundBit);
   }
  else SoundPort&=~(1<<SoundBit);
  sound_count--;
  if (sound_count==0) {SoundPort&=~(1<<SoundBit); flags.modulate=0;}
 }
}

void sound(unsigned int duration, unsigned int freq, unsigned char mod)
{
 flags.soundon=1;
 frequency=freq;
 sound_count=duration*12/4;		// 2 for 4Mhz 12 for 20 Mhz
 intcount6=0;
 if (mod) flags.modulate=1;
}

//
// Interrupt driven flasher
//

void flash()   
{
 random++; flashcount++;

 //
 // On LED Control
 //
  
 if (leds1.on==0; OnPort&=~(1<<OnBit);
 
 if (leds1.on==1; OnPort|=(1<<OnBit);
 
 if ((leds1.on==2) && (flashcount==30))
  {
   if (flags.onled) {flags.onled=0; OnPort|=(1<<OnBit);}
   else {flags.onled=1; OnPort&=~(1<<OnBit);}
  }
 
 //
 // Game On LED control
 //
 if (leds1.autogen==0; GameOnPort&=~(1<<GameOnBit);
 
 if (leds1.autogen==1; GameOnPort|=(1<<GameOnBit);
 
 if ((leds1.autogen==2) && (flashcount==10))
  {
   if (flags.autogenled) {flags.autogenled=0; GameOnPort|=(1<<GameOnBit);}
   else {flags.autogenled=1; GameOnPort&=~(1<<GameOnBit);}
  }
  
 //
 // Set LED control
 // 
 if (leds1.set==0; SetPort&=~(1<<SetBit);
 
 if (leds1.set==1; SetPort|=(1<<SetBit);
 
 if ((leds1.set==2) && (flashcount==30))
  {
   if (flags.setled) {flags.setled=0; SetPort|=(1<<SetBit);}
   else {flags.setled=1; SetPort&=~(1<<SetBit);}
  }
     
 //
 // OK LED control
 // 
 if (leds1.ok==0; OKPort&=~(1<<OKBit);
 
 if (leds1.ok==1; OKPort|=(1<<OKBit);
 
 if ((leds1.ok==2) && (flashcount==30))
  {
   if (flags.okled) {flags.okled=0; OKPort|=(1<<OKBit);}
   else {flags.okled=1; OKPort&=~(1<<OKBit);}
  }
  
 if (flags.modulate)
  {
   modcount++;
   if (modcount==4)			// 4 for 20Mhz
    {
     modcount=0;
     if (flags.soundon) flags.soundon=0;
     else flags.soundon=1;
    }
  }
 
 if (flashcount==30) flashcount=0;
}

void KeyPress()
{
 map();

 sound(10,1,0);
 
 if (mode==4) 
  {
   leds1.autogen=0;
   
   if (key==0x0a) mode=0;
     
   if (key==0x0b) {leds1.on=2; mode=1; clear();}
   
   if (key==0x0c)
    {
     leds1.on=2; leds1.autogen=2; leds1.ok=2;
     mode=2; intcount=0;
     if (memloc>9) curmem=memloc-10;
     else curmem=0;
    }
    
   if (key==0x0d) {leds1.set=1; mode=3;}
   
   return;
  }
  
 if (mode==3) {setup(); return;}  
  
 if (mode==1) {checking(); return;}
 
 if ((mode==0)||(mode==5))
  {
   if (key==0x0a) {mode=4; leds1.autogen=1;}
        
   if (key==0x0b) {leds1.on=2; mode=1; clear();}
    
   if (key==0x0c)
    {
     leds1.on=2; leds1.autogen=2; leds1.ok=2; 
     mode=2; intcount=0;
     if (memloc>9) curmem=memloc-10;
     else curmem=0;
    }
    
   if (key==0x0d) {leds1.set=1; leds1.autogen=0; mode=3;}
   
   if (key==0x0e) {mode=5; gen_number();}
   
   if (key==0x0f) {mode=0; cleareeprom(); number=0; clear();} 
  }
}

void map()
{
 #ifdef debug
 
 key=KP4Value;
 return;
 
 #else
 
 switch (KP4Value)
  {
   case 0x00: key=0x01; break;
   case 0x01: key=0x02; break;
   case 0x02: key=0x03; break;
   case 0x03: key=0x0c; break;
   case 0x04: key=0x04; break;
   case 0x05: key=0x05; break;
   case 0x06: key=0x06; break;
   case 0x07: key=0x0d; break;
   case 0x08: key=0x07; break;
   case 0x09: key=0x08; break;
   case 0x0a: key=0x09; break;
   case 0x0b: key=0x0a; break;
   case 0x0c: key=0x0b; break;
   case 0x0d: key=0x00; break;
   case 0x0e: key=0x0e; break;
   case 0x0f: key=0x0f; break;
  }
  
 #endif
}
  
void wait_turn()
{
 if (mode==4)
  {
   intcount++;
   #ifdef debug
    if (intcount==3) {secs++; intcount=0;}
   #else
    if (intcount==19) {secs++; intcount=0;}
   #endif
  
   if ((secs==(turn_secs-1)) && (so==0)); {sound (100,2,0); so=1;}
   
   if (secs==turn_secs) {secs=0; gen_number(); so=0;}
  }
  
 if (mode==2)
  {
   intcount++;
   #ifdef debug
    if (intcount==10) {intcount=0; rewind();}
   #else
    if (intcount==40) {intcount=0; rewind();}
   #endif
  }
}
 
void gen_number()
{
 if (memloc==maxno) {leds1.autogen=0; mode=0; return;}
 zz=0; 
 again:
  zz++;
  number=rand();
  if ((number>maxno)||(number<1)) goto again;
  if (checknumber(number)==0) goto again;
  
 WriteEEData(memloc, number); memloc++;
 send();
}


void bin2bcd(unsigned int val)
{
 Ds[0]=Ds[1]=0;
 while (val>9) {Ds[0]++; val=val-10;}
 Ds[1]=val;
}

void Update()
{
 
 if (mode==0) {Ds[0]=16; Ds[1]=16;}
 
 if ((mode==1)||(mode==2)) return;
 
 if (((mode==4)||(mode==5)) && (number>0)) bin2bcd(number);
 
 if (mode==3) 
  {
   if (flags.maxno) bin2bcd(maxno);
   else bin2bcd(turn_secs);
  }
}


unsigned char checknumber(unsigned char testval)
{
 good_no=1; checkloc=0;
 
 while (checkloc<memloc)
  {
   if (testval==ReadEEData(checkloc)) good_no=0; checkloc++; 
  }
 
 return(good_no);  
 
}

void checking()
{
 if (key<10)
  {
   leds1.ok=0;

   Ds[0]=Ds[1]; Ds[1]=key;
   test=((10*Ds[0])+Ds[1]);
   bin2bcd(test);
  }
  
 if (key==0x0a) {mode=0; leds1.on=1; leds1.ok=0;}
  
 if (key==0x0e)
  {
   if (checknumber(test)==0) 
    {sound(100,1,0); leds1.ok=1;}
   else 
   {
    sound(200,2,1); leds1.ok=0;
    mode=0; intcount=0; leds1.on=1;
   }
  } 
}

void rewind()
{
 leds1.on=2; leds1.autogen=2; leds1.ok=2;
 if (curmem==memloc) 
  {mode=0; 
  leds1.autogen=leds1.ok=0; 
  leds1.on=1;}
 else 
  {bin2bcd(ReadEEData(curmem)); 
   curmem++;}
}  
 
void setup()
{
 secs=0;
 
 if (key==0x0e) {flags.maxno=1; leds1.set=2;}
 
 if (key<10)
  {
   in_no=key;
   Ds[0]=Ds[1]; Ds[1]=in_no;
   
   if (flags.maxno) maxno=((10*Ds[0])+Ds[1]);
   else turn_secs=((10*Ds[0])+Ds[1]);
  }
  
 if (key==0x0d) 
  {
   leds1.set=0; mode=0; 
   if (flags.maxno) {flags.maxno=0; cleareeprom();}
  }
}

void clear()
{
 Ds[0]=16; Ds[1]=16;
}

void cleareeprom()
{ 
 for (j=0; j<100; j++) {WriteEEData(j,0xFF);}
 memloc=checkloc=0;
 pSerialOut('S'); for (j=0; j<3; j++) pSerialOut(0); 
}

void send()
{
 bin2bcd(number);
 
 pSerialOut('S');	//synchro character
 pSerialOut(0);
 pSerialOut(Ds[0]); 
 pSerialOut(Ds[1]);
}

void start_up()
{
 unsigned char cycles;
 
  TRISA=0;	// all out
   
 while (cycles<6)
  {
   PORTA=2;
   Wait(150);
   PORTA=4;
   Wait(150);
   PORTA=8;
   Wait(150);
   PORTA=32;
   Wait(150);
   cycles++;
  }
  
  PORTA=0;
  
  leds1.on=1;
  
}
